/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.file;

import fr.arinonia.bootstrap.utils.OperatingSystem;
import fr.arinonia.bootstrap.utils.Util;
import fr.arinonia.bootstrap.utils.logger.Logger;
import java.io.File;

public class FileManager {
    private static final Logger LOGGER = Logger.getLogger("FileManager");
    private File appFolder;
    private File launcherFolder;
    private File launcherFile;
    private File runtimeFolder;
    private File javaRuntimeFolder;
    private File javaExecutable;

    public void init() {
        LOGGER.info("Initialising file manager...");
        this.appFolder = this.resolveAppFolderPath();
        if (!this.appFolder.exists() && !this.appFolder.mkdirs()) {
            throw new RuntimeException("Couldn't create application folder: " + this.appFolder.getAbsolutePath());
        }
        this.launcherFolder = new File(this.appFolder, "launcher");
        this.launcherFile = new File(this.launcherFolder, "launcher.jar");
        this.runtimeFolder = new File(this.appFolder, "runtimes");
        this.javaRuntimeFolder = new File(this.runtimeFolder, "java-8");
        this.javaExecutable = this.resolveJavaExecutablePath(this.javaRuntimeFolder);
        LOGGER.info("File manager initialised");
        LOGGER.info("Runtime folder: {}", this.runtimeFolder.getAbsolutePath());
        LOGGER.info("Java 8 runtime: {}", this.javaRuntimeFolder.getAbsolutePath());
    }

    private File resolveAppFolderPath() {
        switch (OperatingSystem.getCurrentPlatform()) {
            case WINDOWS: {
                String appData = System.getenv("APPDATA");
                if (appData != null) {
                    return new File(appData, "BonkersLauncher");
                }
                return new File(System.getProperty("user.home"), "AppData/Roaming/BonkersLauncher");
            }
            case MACOS: {
                return new File(System.getProperty("user.home"), "Library/Application Support/BonkersLauncher");
            }
        }
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (xdgDataHome != null) {
            return new File(xdgDataHome, "BonkersLauncher");
        }
        return new File(System.getProperty("user.home"), ".local/share/BonkersLauncher");
    }

    private File resolveJavaExecutablePath(File javaRuntimeFolder) {
        switch (OperatingSystem.getCurrentPlatform()) {
            case WINDOWS: {
                return new File(javaRuntimeFolder, "bin" + File.separator + "java.exe");
            }
        }
        return new File(javaRuntimeFolder, "bin" + File.separator + "java");
    }

    public boolean isJavaRuntimeInstalled() {
        return this.javaExecutable.exists() && this.javaExecutable.canExecute();
    }

    public String getJavaExecutablePath() {
        if (this.javaExecutable.exists()) {
            LOGGER.info("Using downloaded Java runtime: {}", this.javaExecutable.getAbsolutePath());
            return this.javaExecutable.getAbsolutePath();
        }
        LOGGER.warn("Downloaded Java runtime not found, falling back to system Java");
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + (OperatingSystem.getCurrentPlatform() == OperatingSystem.WINDOWS ? "java.exe" : "java");
    }

    public void prepareJavaRuntimeInstallation() {
        if (!this.runtimeFolder.exists() && !this.runtimeFolder.mkdirs()) {
            throw new RuntimeException("Couldn't create runtime folder: " + this.runtimeFolder.getAbsolutePath());
        }
        if (!this.javaRuntimeFolder.exists() && !this.javaRuntimeFolder.mkdirs()) {
            throw new RuntimeException("Couldn't create Java runtime folder: " + this.javaRuntimeFolder.getAbsolutePath());
        }
    }

    public File getAppFolder() {
        if (!Util.checkFolder(this.appFolder)) {
            throw new RuntimeException("Couldn't get application folder");
        }
        return this.appFolder;
    }

    public File getLauncherFolder() {
        if (!Util.checkFolder(this.launcherFolder)) {
            throw new RuntimeException("Couldn't get launcher folder");
        }
        return this.launcherFolder;
    }

    public File getLauncherFile() {
        return this.launcherFile;
    }

    public File getRuntimeFolder() {
        if (!Util.checkFolder(this.runtimeFolder)) {
            throw new RuntimeException("Couldn't get runtime folder");
        }
        return this.runtimeFolder;
    }

    public File getJavaRuntimeFolder() {
        return this.javaRuntimeFolder;
    }

    public File getJavaExecutable() {
        return this.javaExecutable;
    }
}

