/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.ui.controls;

import fr.arinonia.bootstrap.ui.theme.ThemeColors;
import fr.arinonia.bootstrap.utils.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class RoundedProgressBar
extends JComponent {
    private int maximum;
    private int minimum;
    private int value;

    public RoundedProgressBar() {
        this.setBackground(new Color(0, 0, 0, 0));
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int width = this.getWidth();
        int height = this.getHeight();
        int cornerRadius = height / 2;
        g2d.setColor(ThemeColors.SHADOW_LIGHT);
        g2d.fillRoundRect(1, 2, width - 1, height - 1, cornerRadius, cornerRadius);
        g2d.setColor(ThemeColors.BACKGROUND_SECONDARY_ALPHA);
        g2d.fillRoundRect(0, 0, width, height, cornerRadius, cornerRadius);
        g2d.setColor(ThemeColors.BORDER_SUBTLE);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawRoundRect(0, 0, width - 1, height - 1, cornerRadius, cornerRadius);
        int progress = Util.crossMult(this.value, this.maximum, width);
        if (progress > 0) {
            GradientPaint progressGradient = new GradientPaint(0.0f, 0.0f, ThemeColors.ACCENT_PRIMARY, 0.0f, height, ThemeColors.ACCENT_SECONDARY);
            g2d.setColor(ThemeColors.withAlpha(ThemeColors.ACCENT_PRIMARY, 60));
            g2d.fillRoundRect(1, 2, progress - 1, height - 3, cornerRadius - 1, cornerRadius - 1);
            g2d.setPaint(progressGradient);
            g2d.fillRoundRect(0, 0, progress, height, cornerRadius, cornerRadius);
            if (progress > cornerRadius) {
                g2d.setColor(ThemeColors.HIGHLIGHT_WHITE);
                g2d.fillRoundRect(0, 0, progress, height / 3, cornerRadius, cornerRadius);
            }
            g2d.setColor(ThemeColors.ACCENT_PRIMARY_ALPHA);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawRoundRect(0, 0, progress - 1, height - 1, cornerRadius, cornerRadius);
        }
        g2d.dispose();
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.repaint();
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.repaint();
    }

    public void setValue(int value) {
        this.value = Math.max(this.minimum, Math.min(this.maximum, value));
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 20);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(50, 10);
    }
}

