/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.updater;

import fr.arinonia.bootstrap.updater.DownloadListener;
import fr.arinonia.bootstrap.updater.DownloadTask;
import fr.arinonia.bootstrap.utils.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadJob {
    private static final Logger LOGGER = Logger.getLogger(DownloadJob.class.getName());
    private final Queue<DownloadTask> remainingFiles = new ConcurrentLinkedQueue<DownloadTask>();
    private final List<DownloadTask> allFiles = Collections.synchronizedList(new ArrayList());
    private final List<DownloadTask> failures = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger remainingThreads = new AtomicInteger();
    private ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    private final String name;
    private final String prefix;
    private final DownloadListener listener;
    private boolean started;

    public DownloadJob(String name, String prefix, DownloadListener listener) {
        this.name = name;
        this.prefix = prefix;
        this.listener = listener;
    }

    public DownloadJob(String name, DownloadListener listener) {
        this(name, "", listener);
    }

    public DownloadJob(String name) {
        this(name, "", null);
    }

    public void addDownloadable(File file, String serverHash, String url) {
        if (this.started) {
            throw new IllegalStateException("Cannot add to download job that has already started");
        }
        DownloadTask task = null;
        try {
            task = new DownloadTask(new URL(url), file, serverHash);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.allFiles.add(task);
        this.remainingFiles.add(task);
    }

    public void popAndDownload() {
        DownloadTask task = null;
        while ((task = this.remainingFiles.poll()) != null) {
            if (task.getNunAttempts() > 5) {
                LOGGER.error("Too many attempts for downloading ", Logger.colored(task.getUrl().getPath(), "\u001b[31m"), " for job '", Logger.colored(this.name, "\u001b[33m"), "'");
                continue;
            }
            try {
                String result = task.download();
                if (this.listener != null) {
                    this.listener.onDownloadProgress(this, this.allFiles.size() - this.remainingFiles.size() + " / " + this.allFiles.size());
                }
                LOGGER.info("Finished downloading ", Logger.colored(task.getDestination().getName(), "\u001b[96m"), " for job '", Logger.colored(this.name, "\u001b[33m"), "'", ": ", result);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't download ", Logger.colored(task.getUrl().getPath(), "\u001b[31m"), " for job '", Logger.colored(this.name, "\u001b[33m"), "'");
                this.remainingFiles.add(task);
                LOGGER.error("Error details: ", e);
            }
        }
        LOGGER.info("download all remaining files, failures: ", this.failures.size());
        if (this.remainingThreads.decrementAndGet() <= 0 && this.listener != null) {
            this.listener.onDownloadJobFinished(this);
        }
    }

    public void startDownloading(ThreadPoolExecutor executor) {
        if (this.started) {
            throw new IllegalStateException("Cannot start download job that as already started !");
        }
        this.started = true;
        if (this.allFiles.isEmpty()) {
            LOGGER.info("Download job '", Logger.colored(this.name, "\u001b[33m"), "' skipped as there are no files to download");
            if (this.listener != null) {
                this.listener.onDownloadJobFinished(this);
            }
        } else {
            int threads = executor.getMaximumPoolSize();
            this.remainingThreads.set(threads);
            LOGGER.info("Download job '", this.name, "' started (", threads, " threads)", this.allFiles.size(), " files)");
            if (this.listener != null) {
                this.listener.onDownloadJobStarted(this);
            }
            for (int i = 0; i < threads; ++i) {
                executor.submit(this::popAndDownload);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    public Queue<DownloadTask> getRemainingFiles() {
        return this.remainingFiles;
    }

    public int getFailures() {
        return this.failures.size();
    }

    public List<DownloadTask> getAllFiles() {
        return this.allFiles;
    }

    public void setExecutorService(int number) {
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(number);
    }

    public boolean isComplete() {
        return this.started && this.remainingFiles.isEmpty() && this.remainingThreads.get() == 0;
    }

    public String toString() {
        return "DownloadJob{name='" + this.name + '\'' + ", prefix='" + this.prefix + '\'' + ", remainingFiles=" + this.remainingFiles + ", allFiles=" + this.allFiles + ", failures=" + this.failures + ", remainingThreads=" + this.remainingThreads + ", executorService=" + this.executorService + ", started=" + this.started + '}';
    }
}

