/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.utils;

import fr.arinonia.bootstrap.utils.logger.Logger;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class UiUtil {
    public static final Logger LOGGER = Logger.getLogger("UiUtil");

    public static BufferedImage getImage(String path) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(UiUtil.class.getResourceAsStream(path));
        }
        catch (IOException e) {
            LOGGER.error("Error while loading image: ", e);
        }
        return image;
    }

    public static ImageIcon getImageIcon(String path) {
        URL url = UiUtil.class.getResource(path);
        if (url == null) {
            LOGGER.error("Error while loading image: ", new NullPointerException("Image not found at path: " + path));
            return null;
        }
        return new ImageIcon(url);
    }

    public static ImageIcon getImageIcon(String path, int width, int height) {
        URL url = UiUtil.class.getResource(path);
        if (url == null) {
            LOGGER.error("Error while loading image: ", new NullPointerException("Image not found at path: " + path));
            return null;
        }
        return new ImageIcon(new ImageIcon(url).getImage().getScaledInstance(width, height, 4));
    }

    public static Icon createScaledIcon(Icon originalIcon, int width, int height) {
        if (originalIcon == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(originalIcon.getIconWidth(), originalIcon.getIconHeight(), 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        originalIcon.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        Image scaledImage = bufferedImage.getScaledInstance(width, height, 4);
        return new ImageIcon(scaledImage);
    }

    public static int getLabelWidth(JLabel label) {
        return label.getFontMetrics(label.getFont()).stringWidth(label.getText());
    }

    public static void setCustomFont(JLabel label, Font font, float size) {
        label.setFont(font != null ? font.deriveFont(size) : label.getFont().deriveFont(size));
    }
}

