/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class Util {
    public static int crossMult(int value, int maximum, int coefficient) {
        return (int)((double)value / (double)maximum * (double)coefficient);
    }

    public static String convertBytesCount(double bytes) {
        if (-1000.0 < bytes && bytes < 1000.0) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950.0 || bytes >= 999950.0) {
            bytes /= 1000.0;
            ci.next();
        }
        return String.format("%.1f %cB", bytes / 1000.0, Character.valueOf(ci.current()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        DigestInputStream stream = null;
        try {
            stream = new DigestInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), MessageDigest.getInstance("MD5"));
            byte[] buffer = new byte[65536];
            int read = stream.read(buffer);
            while (read >= 1) {
                read = stream.read(buffer);
            }
            Util.closeSilently(stream);
        }
        catch (Exception ignored) {
            String string = "";
            return string;
        }
        finally {
            Util.closeSilently(stream);
        }
        return String.format("%1$032x", new BigInteger(1, stream.getMessageDigest().digest()));
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getContentURL(String theUrl) {
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            URL url = new URL(theUrl);
            URLConnection urlConnection = url.openConnection();
            urlConnection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
            String redirect = urlConnection.getHeaderField("Location");
            if (redirect != null) {
                urlConnection = new URL(redirect).openConnection();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static boolean checkFolder(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        if (!file.isDirectory() && file.delete()) {
            return file.mkdirs();
        }
        return file.exists() && file.isDirectory();
    }

    public static ArrayList<File> listFiles(File folder) {
        File[] files = folder.listFiles();
        ArrayList<File> list = new ArrayList<File>();
        if (files == null) {
            return list;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                list.addAll(Util.listFiles(f));
                continue;
            }
            list.add(f);
        }
        return list;
    }
}

